﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using System.Diagnostics;
using Microsoft.Phone.Notification;
using System.IO;
using System.IO.IsolatedStorage;
using System.Xml.Serialization;

namespace ReceiveRaw
{
    public partial class MainPage : PhoneApplicationPage
    {
        string channelName = "RawNotification";
        HttpNotificationChannel channel;
        private List<Student> student;

        // Constructor
        public MainPage()
        {
            InitializeComponent();

            student = new List<Student>();
            channel = HttpNotificationChannel.Find(channelName);

            if (channel == null)
            {
                channel = new HttpNotificationChannel(channelName);
                channel.ChannelUriUpdated += channel_ChannelUriUpdated;
                channel.ErrorOccurred += channel_ErrorOccured;
                channel.HttpNotificationReceived += channel_HttpNotificationReceived;
                channel.Open();

                channel.BindToShellTile();
            }
            else
            {
                channel.ChannelUriUpdated += channel_ChannelUriUpdated;
                channel.ErrorOccurred += channel_ErrorOccured;
                channel.HttpNotificationReceived += channel_HttpNotificationReceived;
            }
        }

        void channel_ErrorOccured(object sender,
                NotificationChannelErrorEventArgs e)
        {
            switch (e.ErrorType)
            {
                case ChannelErrorType.ChannelOpenFailed:
                    break;
            }
        }

        void channel_ChannelUriUpdated(object sender,
            NotificationChannelUriEventArgs e)
        {
            Debug.WriteLine(e.ChannelUri.ToString());
        }

        void channel_HttpNotificationReceived(object sender, HttpNotificationEventArgs e)
        {
            string message;
            using (StreamReader reader = new StreamReader(e.Notification.Body))
            {
                XmlSerializer xs = new XmlSerializer(typeof(List<Student>));
                student = (List<Student>)xs.Deserialize(reader);
                message = reader.ReadToEnd();
            }
            //Dispatcher.BeginInvoke(() => MessageBox.Show(message));
            Dispatcher.BeginInvoke(() => lbStudents.ItemsSource = student);
        }

        public class Student
        {
            public long StudentNumber { get; set; }
            public string FirstName { get; set; }
            public string LastName { get; set; }
        }
    }
}